package com.burhanstore.neonbubblequest.act

import android.app.Activity
import android.graphics.Color
import android.os.Bundle
import android.webkit.WebChromeClient
import android.webkit.WebResourceError
import android.webkit.WebResourceRequest
import android.webkit.WebSettings
import android.webkit.WebView
import android.webkit.WebViewClient
import androidx.appcompat.app.AppCompatActivity
import com.burhanstore.neonbubblequest.Utils.DialogManager
import com.burhanstore.neonbubblequest.Utils.anim.setClick
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.databinding.ActivityPageViewBinding
import org.apache.commons.text.StringEscapeUtils

class PageViewActivity : AppCompatActivity() {

    private lateinit var binding: ActivityPageViewBinding
    private lateinit var activity: Activity
    private lateinit var manager: UserManager


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityPageViewBinding.inflate(layoutInflater)
        setContentView(binding.root)
        activity = this


        manager = UserManager.getInstance(activity)
        DialogManager.initDialog(activity)

        val pageName = intent.getStringExtra("page_name")
        val pageContentEscaped = intent.getStringExtra("page_content")

        binding.imageView2.setClick {
            finish()
        }

        binding.pageName.text = pageName

        val pageContent = pageContentEscaped?.let {
            StringEscapeUtils.unescapeHtml4(it)
        } ?: "<html><body><p>No content provided</p></body></html>"

        setupWebView(pageContent)


    }

    private fun setupWebView(htmlContent: String) {
        binding.PageView.apply {
            webViewClient = object : WebViewClient() {
                override fun onPageFinished(view: WebView?, url: String?) {
                    super.onPageFinished(view, url)
                    //   binding.progressBar.visibility = View.GONE
                }

                override fun onReceivedError(
                    view: WebView?,
                    request: WebResourceRequest?,
                    error: WebResourceError?
                ) {
                    //        Toast.makeText(activity, "Failed to load content", Toast.LENGTH_SHORT).show()
                    //   binding.progressBar.visibility = View.GONE
                }
            }

            webChromeClient = WebChromeClient()

            settings.apply {
                javaScriptEnabled = true
                domStorageEnabled = true
                loadsImagesAutomatically = true
                cacheMode = WebSettings.LOAD_DEFAULT
                allowFileAccess = true
            }

            setBackgroundColor(Color.TRANSPARENT)
            setLayerType(WebView.LAYER_TYPE_SOFTWARE, null)

            loadDataWithBaseURL(
                null,
                """
                <html>
                <head>
                <style>body { background-color: transparent; margin:0; padding:10px; font-family: sans-serif; }</style>
                </head>
                <body>
                $htmlContent
                </body>
                </html>
                """.trimIndent(),
                "text/html",
                "utf-8",
                null
            )
        }
    }

    override fun onDestroy() {
        binding.PageView.apply {
            clearHistory()
            loadUrl("about:blank")
            onPause()
            removeAllViews()
            destroy()
        }
        super.onDestroy()
    }


    override fun onResume() {
        super.onResume()
    }


}